dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 5, 200, 360, "assets/images/table/castle_6", "assets/images/food/item_mark1", "B" );
LManager:AddNewTable( 2, 5, 230, 220, "assets/images/table/castle_6", "assets/images/food/item_mark2", "B" );
LManager:AddNewTable( 3, 5, 220, 485, "assets/images/table/castle_6", "assets/images/food/item_mark4", "R" );

useFloAsServer = 0;

useWineTable = 1;
numMoodBoosts = 3;
maxCoupleHappiness = 500;

--Level 5.5

--Group 1

guest = LManager.GenGuest(female03);
guest.matchType = table1;
guest.percentRequestDrink = 70;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.percentRequestTissue = 30;
guest.matchType = uncle;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = female03;
guest.likes={female01};
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.percentRequestCoffee = 30;
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 5, 1000);


--Group 2
guest = LManager.GenGuest(female04);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female04;
guest.percentRequestDrink = 70;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(6, 8, 20000);


guest = LManager.GenGuest(male02);
guest.matchType = male01;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 10, 40000);

--Group 3
guest = LManager.GenGuest(male01);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male04;
guest.percentRequestDrink = 60;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female01;
LManager:AddGuest(guest);


guest = LManager.GenGuest(female04);
guest.matchType = female03;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 15, 55000);


--Group 4
guest = LManager.GenGuest(female04);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.percentRequestTissue = 30;
guest.matchType = female04
LManager:AddGuest(guest);

LManager:SetSeatingGroup(16, 17, 80000);


--Group 5
guest = LManager.GenGuest(female04);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.percentRequestCoffeee = 30;
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.percentRequestTissue = 80;
guest.matchType = uncle;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = NOT_GUEST + uncle;
guest.percentRequestMusic = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 22, 120000);


--Group 6
guest = LManager.GenGuest(male01);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female03;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male02;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table3;
guest.percentRequestMusic = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + uncle;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(23, 28, 160000);


--Group 7
guest = LManager.GenGuest(male01);
guest.matchType = male03;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.likes={female03};
guest.matchType = male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(29, 32, 200000);


--Group 8
guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(33, 34, 250000);



LManager:AdjustGuestTolerance(140);

LManager:SetLevelSetting ("bridesmaidsDelay", 100000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 160000 );

LManager:SetLevelSetting ("cakeTipDelay", 220000);
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:AddReseatingRequestForGuest(36000, male03);
LManager:AddReseatingRequestForGuest(310000, male03);

-- Set up the Level Settings
LManager:SetLevelNumber(5,5);
LManager:SetLevelScores(16000, 19000);
LManager:SetLevelTime(500000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/new_dance_4.ogg","assets/audio/music/Disco Dance 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_castle");
LManager:SetChairImage("assets/images/table/chair05");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );